#include <bits/stdc++.h>
using namespace std;

tuple<long long, long long, long long> get_2p_line(pair<long long, long long> s1, pair<long long, long long> s2) {
    return make_tuple(s1.second - s2.second, s2.first - s1.first, s2.second * s1.first - s2.first * s1.second);
}

long long get_halfplane(pair<long long, long long> s, tuple<long long, long long, long long> pl) {
    return s.first * get<0>(pl) + s.second * get<1>(pl) + get<2>(pl);
}

bool evaluate_segments(pair<pair<long long, long long>, pair<long long, long long>> t1, pair<pair<long long, long long>, pair<long long, long long>> t2) {
    tuple<long long, long long, long long> pl1(get_2p_line(t1.first, t1.second));
    tuple<long long, long long, long long> pl2(get_2p_line(t2.first, t2.second));
    long long a(get_halfplane(t1.first, pl2)), b(get_halfplane(t1.second, pl2));
    long long c(get_halfplane(t2.first, pl1)), d(get_halfplane(t2.second, pl1));
    if (a > b) {
        swap(a, b);
    }
    if (c > d) {
        swap(c, d);
    }
    if ((a == 0) && (b == 0) && (c == 0) && (d == 0)) {
        if (t1.first == t2.first) {
            return true;
        }
        if (t1.first == t2.second) {
            return true;
        }
        if (t1.second == t2.first) {
            return true;
        }
        if (t1.second == t2.second) {
            return true;
        }
        return false;
    }
    //cout << a << " " << b << " " << c << " " << d << endl;
    if (((a <= 0) && (b >= 0)) && ((c <= 0) && (d >= 0))) {
        return true;
    }
    return false;
}

void graph_search(vector<vector<bool>>& table, vector<bool>& used, int x) {
    used[x] = true;
    for (int i = 0; i < (int)(table.size()); i++) {
        if (table[x][i]) {
            if (!used[i]) {
                graph_search(table, used, i);
            }
        }
    }
}

void get_segment_data() {
    int n, p, q, r, s;
    cin >> n;
    vector<pair<pair<long long, long long>, pair<long long, long long>>> v{};
    int res(1 - n);
    for (int i = 0; i < n; i++) {
        cin >> p >> q >> r >> s;
        v.push_back({{p, q}, {r, s}});
    }
    vector<vector<bool>> table(n, vector<bool>(n, false));
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < i; j++) {
            if (evaluate_segments(v[i], v[j])) {
                //cout << i << " " << j << endl;
                table[i][j] = true;
                table[j][i] = true;
                res++;
            }
        }
    }
    vector<bool> used(n, false);
    for (int i = 0; i < n; i++) {
        if (!used[i]) {
            res++;
            graph_search(table, used, i);
        }
    }
    cout << res << endl;
}

int main() {
    int t;
    cin >> t;
    for (int i = 0; i < t; i++) {
        get_segment_data();
    }
}
